/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.lookup.IHierarchyLookup;

public class CommonRegistrationSession {
    private final WailaCommonRegistration registration;
    private boolean active;
    private final List<Pair<IServerDataProvider<BlockAccessor>, Class<?>>> blockDataProviders = Lists.newArrayList();
    private final List<Pair<IServerDataProvider<EntityAccessor>, Class<? extends class_1297>>> entityDataProviders = Lists.newArrayList();
    private final List<Pair<IServerExtensionProvider<class_1799>, Class<?>>> itemStorageProviders = Lists.newArrayList();
    private final List<Pair<IServerExtensionProvider<class_2487>, Class<?>>> fluidStorageProviders = Lists.newArrayList();
    private final List<Pair<IServerExtensionProvider<class_2487>, Class<?>>> energyStorageProviders = Lists.newArrayList();
    private final List<Pair<IServerExtensionProvider<class_2487>, Class<?>>> progressProviders = Lists.newArrayList();

    public CommonRegistrationSession(WailaCommonRegistration registration) {
        this.registration = registration;
    }

    private static <T extends IJadeProvider, C> void register(T provider, List<Pair<T, Class<? extends C>>> list, IHierarchyLookup<T> lookup, Class<? extends C> clazz) {
        Preconditions.checkArgument((boolean)lookup.isClassAcceptable(clazz), (String)"Class %s is not acceptable", clazz);
        Objects.requireNonNull(provider.getUid());
        list.add(Pair.of(provider, clazz));
    }

    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<?> blockOrBlobkEntityClass) {
        CommonRegistrationSession.register(dataProvider, this.blockDataProviders, this.registration.blockDataProviders, blockOrBlobkEntityClass);
    }

    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends class_1297> entityClass) {
        CommonRegistrationSession.register(dataProvider, this.entityDataProviders, this.registration.entityDataProviders, entityClass);
    }

    public <T> void registerEnergyStorage(IServerExtensionProvider<class_2487> provider, Class<? extends T> clazz) {
        CommonRegistrationSession.register(provider, this.energyStorageProviders, this.registration.energyStorageProviders, clazz);
    }

    public <T> void registerItemStorage(IServerExtensionProvider<class_1799> provider, Class<? extends T> clazz) {
        CommonRegistrationSession.register(provider, this.itemStorageProviders, this.registration.itemStorageProviders, clazz);
    }

    public <T> void registerFluidStorage(IServerExtensionProvider<class_2487> provider, Class<? extends T> clazz) {
        CommonRegistrationSession.register(provider, this.fluidStorageProviders, this.registration.fluidStorageProviders, clazz);
    }

    public <T> void registerProgress(IServerExtensionProvider<class_2487> provider, Class<? extends T> clazz) {
        CommonRegistrationSession.register(provider, this.progressProviders, this.registration.progressProviders, clazz);
    }

    public void reset() {
        this.blockDataProviders.clear();
        this.entityDataProviders.clear();
        this.itemStorageProviders.clear();
        this.fluidStorageProviders.clear();
        this.energyStorageProviders.clear();
        this.progressProviders.clear();
        this.active = true;
    }

    public void end() {
        Preconditions.checkState((boolean)this.active, (Object)"Session is not active");
        this.active = false;
        this.blockDataProviders.forEach(pair -> this.registration.registerBlockDataProvider((IServerDataProvider)pair.getFirst(), (Class)pair.getSecond()));
        this.entityDataProviders.forEach(pair -> this.registration.registerEntityDataProvider((IServerDataProvider)pair.getFirst(), (Class)pair.getSecond()));
        this.itemStorageProviders.forEach(pair -> this.registration.registerItemStorage((IServerExtensionProvider)pair.getFirst(), (Class)pair.getSecond()));
        this.fluidStorageProviders.forEach(pair -> this.registration.registerFluidStorage((IServerExtensionProvider)pair.getFirst(), (Class)pair.getSecond()));
        this.energyStorageProviders.forEach(pair -> this.registration.registerEnergyStorage((IServerExtensionProvider)pair.getFirst(), (Class)pair.getSecond()));
        this.progressProviders.forEach(pair -> this.registration.registerProgress((IServerExtensionProvider)pair.getFirst(), (Class)pair.getSecond()));
    }

    public boolean isActive() {
        return this.active;
    }
}

